@echo off
setlocal

REM setting service name, source path, dest path and working directory

set "SERVICE_NAME=TecnoHWService"
set "BIN=TecnoHWService.exe"
set "SOURCE_PATH=%~dp0"
set "DEST_DIR=C:\Program Files\TecnoHWService\"
set "WORKING_DIRECTORY=C:\Program Files\TecnoHWService"


echo.
echo 1. Install service
echo 2. Remove service
echo Please select operation (input 1 or 2):

set /p choice=

if "%choice%"=="1" (
    echo Stop/Delete service...
    
    sc stop "%SERVICE_NAME%"
    sc delete "%SERVICE_NAME%"
    
    echo Install service...

    echo Copy files...


    if not exist "%DEST_DIR%" mkdir "%DEST_DIR%"
    xcopy "%SOURCE_PATH%*" "%DEST_DIR%" /E /I /C /y
    if errorlevel 1 (
        echo Copy files failed. make sure source path and dest path are correct.
        goto end
    )

    REM create service
   
    sc create "%SERVICE_NAME%" binPath= "\"%DEST_DIR%%BIN%""
    sc config "%SERVICE_NAME%" start= auto

    echo Setting WorkingDirectory...
    reg add "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\%SERVICE_NAME%" /v WorkingDirectory /t REG_SZ /d "%WORKING_DIRECTORY%" /f

    echo Start service...
    sc start "%SERVICE_NAME%"

    echo Service created and started.

    echo Set the app to start automatically...
    reg add "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" /v TecnoHWApp /t REG_SZ /d "\"%DEST_DIR%TecnoHWApp.exe\"" /f > NUL

    echo Starting app...
    start "" "%DEST_DIR%TecnoHWApp.exe"

    echo App was installed and started.

) else if "%choice%"=="2" (
    echo Stop service...
    sc stop "%SERVICE_NAME%"
    echo Delete service...
    sc delete "%SERVICE_NAME%"
    echo Service deleted.

    reg delete "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" /v TecnoHWApp /f > NUL
	taskkill /F /IM TecnoHWApp.exe
	ping 127.0.0.1 /n 2 > NUL
    rd /s /q "%DEST_DIR%"
    echo Service uninstalled successfully.
) else (
    echo Invalid choice.
)

:end
endlocal
pause
